/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.ExtendedPlayer;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.capabilities.IExtendedEntity;
import com.lycanitesmobs.core.capabilities.IExtendedPlayer;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.EntityItemCustom;
import com.lycanitesmobs.core.info.ItemInfo;
import com.lycanitesmobs.core.item.ItemBase;
import com.lycanitesmobs.core.item.ItemSwordBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventListener {
    @SubscribeEvent
    public void onWorldLoading(WorldEvent.Load event) {
        if (event.getWorld() == null) {
            return;
        }
        ExtendedWorld.getForWorld(event.getWorld());
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityLivingBase) {
            event.addCapability(new ResourceLocation("lycanitesmobs", "IExtendedEntity"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IExtendedEntity instance = (IExtendedEntity)LycanitesMobs.EXTENDED_ENTITY.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LycanitesMobs.EXTENDED_ENTITY;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LycanitesMobs.EXTENDED_ENTITY ? LycanitesMobs.EXTENDED_ENTITY.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LycanitesMobs.EXTENDED_ENTITY.getStorage().writeNBT(LycanitesMobs.EXTENDED_ENTITY, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    LycanitesMobs.EXTENDED_ENTITY.getStorage().readNBT(LycanitesMobs.EXTENDED_ENTITY, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
        if (event.getEntity() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("lycanitesmobs", "IExtendedPlayer"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IExtendedPlayer instance = (IExtendedPlayer)LycanitesMobs.EXTENDED_PLAYER.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == LycanitesMobs.EXTENDED_PLAYER;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == LycanitesMobs.EXTENDED_PLAYER ? LycanitesMobs.EXTENDED_PLAYER.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)LycanitesMobs.EXTENDED_PLAYER.getStorage().writeNBT(LycanitesMobs.EXTENDED_PLAYER, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    LycanitesMobs.EXTENDED_PLAYER.getStorage().readNBT(LycanitesMobs.EXTENDED_PLAYER, (Object)this.instance, null, (NBTBase)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(event.getOriginal());
        if (extendedPlayer != null) {
            extendedPlayer.backupPlayer();
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() == null || event.getEntity().func_130014_f_() == null || event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLivingBase) && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS != null && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS.length > 0) {
            LycanitesMobs.printDebug("ForceRemoveEntity", "Forced entity removal, checking: " + event.getEntity().func_70005_c_());
            for (String forceRemoveID : ExtendedEntity.FORCE_REMOVE_ENTITY_IDS) {
                if (!forceRemoveID.equalsIgnoreCase(event.getEntity().func_70005_c_())) continue;
                event.getEntity().func_70106_y();
                break;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        EntityPlayer player;
        ExtendedPlayer extendedPlayer;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.onDeath();
        }
        if (entity instanceof EntityPlayer && (extendedPlayer = ExtendedPlayer.getForPlayer(player = (EntityPlayer)entity)) != null) {
            extendedPlayer.onDeath();
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        ExtendedPlayer playerExt;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.onUpdate();
        }
        if (entity instanceof EntityPlayer && (playerExt = ExtendedPlayer.getForPlayer(player = (EntityPlayer)entity)) != null) {
            playerExt.onUpdate();
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            ItemStack equippedItemStack;
            EntityPlayer entityPlayer = (EntityPlayer)event.getEntityLiving();
            if (entityPlayer.func_184586_b(EnumHand.MAIN_HAND) != null && (equippedItemStack = entityPlayer.func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof ItemSwordBase) {
                ((ItemSwordBase)equippedItemStack.func_77973_b()).onEarlyUpdate(equippedItemStack, event.getEntityLiving(), EnumHand.MAIN_HAND);
            }
            if (entityPlayer.func_184586_b(EnumHand.OFF_HAND) != null && (equippedItemStack = entityPlayer.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() instanceof ItemSwordBase) {
                ((ItemSwordBase)equippedItemStack.func_77973_b()).onEarlyUpdate(equippedItemStack, event.getEntityLiving(), EnumHand.OFF_HAND);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        Entity entity = event.getTarget();
        if (player == null || entity == null) {
            return;
        }
        if (player.func_184586_b(event.getHand()) != null) {
            ItemStack itemStack = player.func_184586_b(event.getHand());
            Item item = itemStack.func_77973_b();
            if (item instanceof ItemBase && ((ItemBase)item).onItemRightClickOnEntity(player, entity, itemStack) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (item instanceof ItemSwordBase && ((ItemSwordBase)item).onItemRightClickOnEntity(player, entity, itemStack) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().func_70644_a(MobEffects.field_76439_r) && event.getTarget() != null && event.getTarget().func_82150_aj()) {
            event.getEntityLiving().func_70604_c(null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource() == null || event.getEntityLiving() == null) {
            return;
        }
        EntityLivingBase damagedEntity = event.getEntityLiving();
        ExtendedEntity damagedEntityExt = ExtendedEntity.getForEntity(damagedEntity);
        EntityDamageSource entityDamageSource = null;
        if (event.getSource() instanceof EntityDamageSource) {
            entityDamageSource = (EntityDamageSource)event.getSource();
        }
        if (damagedEntity.func_184187_bx() != null && damagedEntity.func_184187_bx() instanceof EntityCreatureRideable) {
            if ("inWall".equals(event.getSource().field_76373_n)) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
            EntityCreatureRideable creatureRideable = (EntityCreatureRideable)event.getEntityLiving().func_184187_bx();
            if (!creatureRideable.isDamageTypeApplicable(event.getSource().field_76373_n)) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
        }
        if (damagedEntityExt != null && damagedEntityExt.isPickedUp() && "inWall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        World world = event.getEntityLiving().func_130014_f_();
        if (ItemInfo.seasonalItemDropChance > 0.0 && (Utilities.isHalloween() || Utilities.isYuletide() || Utilities.isNewYear())) {
            boolean noSeaonalDrop = false;
            boolean alwaysDrop = false;
            if (event.getEntityLiving() instanceof EntityCreatureBase) {
                if (((EntityCreatureBase)event.getEntityLiving()).isMinion()) {
                    noSeaonalDrop = true;
                }
                if (((EntityCreatureBase)event.getEntityLiving()).getSubspecies() != null) {
                    alwaysDrop = true;
                }
            }
            Item seasonalItem = null;
            if (Utilities.isHalloween()) {
                seasonalItem = ObjectManager.getItem("halloweentreat");
            }
            if (Utilities.isYuletide()) {
                seasonalItem = ObjectManager.getItem("wintergift");
                if (Utilities.isYuletideDay() && world.field_73012_v.nextBoolean()) {
                    seasonalItem = ObjectManager.getItem("wintergiftlarge");
                }
            }
            if (seasonalItem != null && !noSeaonalDrop && (alwaysDrop || (double)event.getEntityLiving().func_70681_au().nextFloat() < ItemInfo.seasonalItemDropChance)) {
                ItemStack dropStack = new ItemStack(seasonalItem, 1);
                EntityItemCustom entityItem = new EntityItemCustom(world, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, dropStack);
                entityItem.func_174867_a(10);
                world.func_72838_d((Entity)entityItem);
            }
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        World world = event.getWorld();
        RayTraceResult target = event.getTarget();
        if (target == null) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        Block block = world.func_180495_p(pos).func_177230_c();
        Item bucket = ObjectManager.buckets.get(block);
        if (bucket != null && (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            world.func_175698_g(pos);
        }
        if (bucket == null) {
            return;
        }
        event.setFilledBucket(new ItemStack(bucket));
        event.setResult(Event.Result.ALLOW);
    }
}

